% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viSNE-class.R
\docType{class}
\name{viSNE-class}
\alias{viSNE-class}
\title{S4 viSNE Class}
\value{
A viSNE advanced analysis object
}
\description{
A viSNE object that holds pertinent viSNE advanced analysis run information.
This class should never be called explicitly. If a user would like to create a new Cytobank viSNE object, utilize the \link{visne.new} function, or any other \link[=visne]{viSNE endpoints that return viSNE objects documented in the 'Details' section}.
}
\section{Slots}{

\describe{
\item{\code{iterations}}{numeric representing the number of times viSNE processes the dataset using its step-wise optimization algorithm, \href{https://support.cytobank.org/hc/en-us/articles/206439707-How-to-Configure-and-Run-a-viSNE-Analysis#iterations}{learn more about how iterations affect viSNE results}}

\item{\code{perplexity}}{dataframe representing a rough guess for the number of close neighbors any given cellular event will have, \href{https://support.cytobank.org/hc/en-us/articles/206439707-How-to-Configure-and-Run-a-viSNE-Analysis#perplexity}{learn more about viSNE perplexity}}

\item{\code{population_selections}}{dataframe representing which population(s) data will be sourced, \href{https://support.cytobank.org/hc/en-us/articles/206439707-How-to-Configure-and-Run-a-viSNE-Analysis#populations}{learn more about selecting populations for viSNE}}

\item{\code{visne_id}}{numeric representing the viSNE analysis ID}

\item{\code{sampling_total_count}}{numeric representing the total number of events to sample for the viSNE analysis}

\item{\code{sampling_target_type}}{character representing the event sampling type\cr
\emph{- choose one of the following : \code{("proportional", "equal")}}}

\item{\code{theta}}{numeric representing the balance of speed and accuracy in the viSNE run compared to the original tSNE algorithm, \href{https://support.cytobank.org/hc/en-us/articles/206439707-How-to-Configure-and-Run-a-viSNE-Analysis#theta}{learn more about viSNE theta}}
}}

