% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/library--data_prep--filter_tools--outlier_tools.R
\name{removeOutliers}
\alias{removeOutliers}
\title{Add column with NA values where the data was flagged}
\usage{
removeOutliers(DF, Messure, Filtcol, outputColName)
}
\arguments{
\item{DF}{DF containing the columns Measure and Filtcol}

\item{Messure}{The original measurement we want to keep inliers for}

\item{Filtcol}{the column containing the Boolean info needed to remove outliers}

\item{outputColName}{the name for the clean column}
}
\value{
DF with new column without the flagged values
}
\description{
Add column with NA values where the data was flagged
}
\examples{
data(Example_data, package = "Covid19Wastewater")
Example_data$site = "Madison"
df_data <- computeJumps(Example_data)
ranked_data <- rankJumps(df_data)
ranked_quantile_data <- computeRankQuantiles(ranked_data)
classied_data <- flagOutliers(ranked_quantile_data, 9)
removeOutliers(classied_data, sars_cov2_adj_load_log10, FlaggedOutlier, sars_adj_log10_Filtered)
}
