% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrectOverloadedPeaks.R
\name{CorrectOverloadedPeaks}
\alias{CorrectOverloadedPeaks}
\title{Correct Overloaded Peaks from GC-MS data.}
\usage{
CorrectOverloadedPeaks(data = NULL, method = c("Isoratio", "Gauss",
  "EMG")[1], detection_limit = 1, ds = NULL, silent = TRUE,
  testing = FALSE, attotwm = FALSE, region = NULL, peak = NULL)
}
\arguments{
\item{data}{An xcmsRaw-object or an mzXML-object as imported by \code{\link{read.mzXML}}.}

\item{method}{Either Gauss or EMG (usually better results) or Isoratio (more robust for non gaussian peak shapes).}

\item{detection_limit}{If=1 only peaks hitting detector saturation (ds) will be corrected, can be lowered to 0.95 to catch also peaks going into saturation.}

\item{ds}{Detector saturation. Will be determined based on data if not specified explicitly.}

\item{silent}{QC-plots will be generated if silent=FALSE and additional Warnings() will be generated.}

\item{testing}{Will automatically set silent=FALSE and store all extracted regions with overloaded peaks in the working directory as \code{cor_df_all.RData}.}

\item{attotwm}{All-the-Time-of-the-World-Mode. If calculation time doesn't matter try this out. :)}

\item{region}{From an initial QC-Plot file you may reprocess a specific overloaded region. Dont forget to specify the ds parameter explicitly.}

\item{peak}{You may further restrict the reprocessing to a specific peak within the region.}
}
\value{
An corrected xcmsRaw- or mzXML-object which can be exported to file. Additionally a QC-plot pdf-file if silent=FALSE.
}
\description{
\code{CorrectOverloadedPeaks} will take an xcmsRaw data structure and search for overloaded peaks within the mass traces.
based on further parameters. It will correct overloaded peaks automatically using an Gaussian or IsotopicRatio approach,
generate QC plots and write the corrected data back into the original xcmsRaw.
}
\details{
This is a high level function to batch pre-process Metabolomics data which are partially overloaded before continuing with
the standard workflow of peak identification etc.. It relies internally on \code{\link{FitGaussPeak}} and \code{\link{FitPeakByIsotopicRatio}}
to modifiy data of individual intensity signal. Basically the function aims to identify automatically overloaded regions
and extracts base peak chromatograms for all overloaded m/z traces within these regions, which are corrected and put back
into the original data structure. For simplicity some potentially interesting parameters are hidden at the top of the 
function definition. They have been set to values determined empirically to be working for a Bruker impact II MS (high-res QTOF)
coupled to GC and LC via APCI and ESI respectively. For more details please see \url{http://dx.doi.org/10.1021/acs.analchem.6b02515}.
}
\examples{
#load xcmsRaw test data, then correct, plot and return reconstructed data
data("xcmsRaw_data")
\donttest{CorrectOverloadedPeaks(data=xcmsRaw_data, method="Gauss", silent=FALSE)}

#load mzXML test data
data(mzXML_data)
\donttest{CorrectOverloadedPeaks(data=mzXML_data, method="EMG", silent=FALSE)}

}
\references{
\url{http://dx.doi.org/10.1021/acs.analchem.6b02515}
}
\seealso{
\code{\link{ModelGaussPeak}}

\code{\link{FitGaussPeak}}

\code{\link{FitPeakByIsotopicRatio}}

\code{\link{read.mzXML}}

\code{\link{write.mzXML}}
}

