\name{SO.LRT}
\alias{SO.LRT}
\title{Likelihood-ratio test statistic}
\description{
\code{SO.LRT} computes the likelihood ratio test statistic for stochastic ordering against equality
assuming marginal compatibility for both alternatives. Note that this statistic does not have
a \eqn{\chi^2}{chi-squared} distribution, so the p-value computation is not straightforward.
The \code{\link{SO.trend.test}} function implements a permutation-based evaluation of the p-value for the 
likelihood-ratio test.
}
\usage{
SO.LRT(cbdata, control = soControl())
}
\arguments{
  \item{cbdata}{a \code{CBData} object}
  \item{control}{an optional list of control settings, usually a call to \code{\link{soControl}}.
    See there for the names of the settable control values and their effect.}
}
\value{
  The value of the likelihood ratio test statistic is returned with two attributes:
  \item{ll0 }{the log-likelihood under \eqn{H_0}{H0} (equality)}
  \item{ll1 }{the log-likelihood under \eqn{H_a}{Ha} (stochastic order)}
}
\author{Aniko Szabo}
\seealso{\code{\link{SO.trend.test}}, \code{\link{soControl}}}
\examples{
data(shelltox)
LRT <- SO.LRT(shelltox, control=soControl(max.iter = 100, max.directions = 50))
LRT
}
\keyword{htest}
\keyword{nonparametric}
