% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosinePerm.R
\name{cosinePerm}
\alias{cosinePerm}
\title{Computes the cosine similarity and significance using permutation test}
\usage{
cosinePerm(x, y, nperm = 1000, alternative = c("two.sided", "less",
  "greater"), include.perm = FALSE, setseed = 12345, nthread = 1)
}
\arguments{
\item{x}{[factor] is the factors for the first variable}

\item{y}{[factor] is the factors for the second variable}

\item{nperm}{[integer] is the number of permutations to comput ethe null distribution of MCC estimates}

\item{alternative}{[string] indicates the alternative hypothesis and must be one of
‘"two.sided"’, ‘"greater"’ or ‘"less"’.  You can specify just
the initial letter.  ‘"greater"’ corresponds to positive
association, ‘"less"’ to negative association.
Options are "two.sided", "less", or "greater"}

\item{include.perm}{[boolean] indicates whether the estimates for the null distribution should be returned.
Default set to 'FALSE'}

\item{setseed}{[integer] is the seed specified by the user. Defaults is '12345'}

\item{nthread}{[integer] is the number of threads to be used to perform the permutations in parallel}
}
\value{
[list] estimate of the cosine similarity, p-value and estimates after random permutations (null distribution) in include.perm is set to 'TRUE'
}
\description{
Computes the cosine similarity and significance using permutation test
}
\examples{
x <- factor(c(1,2,1,2,1))
y <- factor(c(2,2,1,1,1))
cosinePerm(x, y)

}
