% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.CopulaCenR.R
\name{predict.CopulaCenR}
\alias{predict.CopulaCenR}
\title{Predictions from CopulaCenR regression models}
\usage{
\method{predict}{CopulaCenR}(object, class = "joint", newdata,
  evalPoints = 50, evalTimes = NULL, cond_time = NULL,
  cond_margin = 2, ...)
}
\arguments{
\item{object}{a CopulaCenR object from ic_sp_copula, ic_par_copula and rc_par_copula}

\item{class}{one of "joint", "conditional" or "marginal"}

\item{newdata}{a data frame with colname names id, ind and covariate names}

\item{evalPoints}{number of time points to be evaluated; default is 50}

\item{evalTimes}{a vector of times to be evaluated within the observed time range; default is NULL; will override evalPoints if non-NULL; if class is "conditional", the evaluation times are evalTimes + cond_time}

\item{cond_time}{for class = "conditional" only; the time by which event has occurred in the margin indicated by cond_margin; must be smaller than the largest observed time}

\item{cond_margin}{for class = "conditional" only; indicator of the margin for which event has occurred (either 1 or 2); default is 2 for ind = 2}

\item{...}{further arguments}
}
\value{
if class is "marginal" or "conditional", return a vector of survival probabilities with time grids;
if class is "joint", returns  a matrix (named surv2, row for event 1, column for event 2) of joint survival probabilities based on the fitted model in object, grid1 (selected times for event 1) and grid2 (selected times for event 2)
}
\description{
Predict survival distribution for a new observation from ic_sp_copula, ic_par_copula and rc_par_copula.
}
\details{
The newdata must be a data frame with columns id (subject id), ind (1,2 for two margins) and covariates. \cr
The argument class determines the prediction output: "joint" for joint survival probabilities,
"conditional" for conditional probabilities and "marginal" or marginal probabilities. The function
evaluates on a series of time points (given by evalPoints or evalTimes; evalTimes will override evalPoints). \cr

If class = "conditional", one needs to specify the margin that has the event (by cond_margin) and time when the event has occurred (by cond_time).
For example, if cond_margin = 2 and cond_time = 5, then the function produces the conditional survival probability (after time 5) in margin 1 given that
margin 2 has got an event by time 5. This measurement is useful for predicting the second event given the first event has occurred. \cr
}
\examples{
data(AREDS)
# fit a Copula2-Sieve model
copula2_sp <- ic_sp_copula(data = AREDS, copula = "Copula2", l = 0, u = 15,
              m = 3, r = 3, var_list = c("ENROLLAGE","rs2284665","SevScaleBL"),
              iter = 300, stepsize = 1e-6, method = "Newton")
# Predicted probabilities for newdata
newdata = data.frame(id = rep(1, each=2), ind = c(1,2), SevScaleBL = c(6,8),
                     ENROLLAGE = c(67,67), rs2284665 = c(1,1))
joint <- predict(object = copula2_sp, class = "joint", newdata = newdata)
conditional <- predict(object = copula2_sp, class = "conditional",
                       newdata = newdata, cond_margin = 2, cond_time = 5)
marginal <- predict(object = copula2_sp, class = "marginal",
                    newdata = newdata)
}
