% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMarginalContributions.R
\name{getMarginalContributions}
\alias{getMarginalContributions}
\title{Compute marginal contributions}
\usage{
getMarginalContributions(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
a list with given game vector, a matrix of combinations
         used and a matrix with the marginal contributions
}
\description{
Calculates the marginal contributions for all permutations of the players
}
\examples{
library(CoopGame)
v=c(0,0,0,1,1,0,1)
getMarginalContributions(v)

}
\references{
Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 156--159

Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, p. 6
}
\author{
Alexandra Tiukkel

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
