% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data.R
\name{prep_data}
\alias{prep_data}
\title{prep_data}
\usage{
prep_data(
  x,
  object_id = NULL,
  account_id = NULL,
  content_id = NULL,
  timestamp_share = NULL
)
}
\arguments{
\item{x}{A data.table or an object that can be converted into a data.table.
This is the dataset whose columns will be renamed.}

\item{object_id}{The current name of the column that should be renamed to "object_id".
If NULL, no renaming is performed on this column.}

\item{account_id}{The current name of the column that should be renamed to "account_id".
If NULL, no renaming is performed on this column.}

\item{content_id}{The current name of the column that should be renamed to "content_id".
If NULL, no renaming is performed on this column.}

\item{timestamp_share}{The current name of the column that should be renamed to "timestamp_share".
The data in this column should be either in UNIX format or in a "\%Y-\%m-\%d \%H:\%M:\%S" format.
If the data is in a different format or conversion is unsuccessful, the function stops with an error.
If NULL, no renaming or conversion is performed on this column.}
}
\value{
A data.table with the specified columns renamed according to the input parameters.
If no renaming is required, the original data.table is returned unaltered.
}
\description{
Function to rename columns of a given data.table. This function standardizes
column names to "object_id", "account_id", "content_id", and "timestamp_share".
It is useful for preparing datasets for further analysis by ensuring
consistent column naming.
}
\details{
This function allows the user to specify the current names of columns in
their data.table that they wish to rename to a standard format. The function
checks for each parameter and renames the corresponding column in the data.table.
If the parameter is NULL, no change is made to that column. The function
ensures the data input is a data.table; if not, it converts it before renaming.
For the 'timestamp_share' column, the function expects the format to be either UNIX format
(integer representing seconds since the Unix epoch) or "\%Y-\%m-\%d \%H:\%M:\%S". If the 'timestamp_share'
is in a different format, the function attempts to convert it to UNIX format using base R functions.
}
\examples{
dt <- data.table::data.table(old_object_id = 1:3, old_account_id_y = 4:6)
dt <- prep_data(dt, object_id = "old_object_id", account_id = "old_account_id_y")

}
