% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf_4dim.R
\name{cf_4dim}
\alias{cf_4dim}
\title{Plot 2D contour slices of four dimensional functions}
\usage{
cf_4dim(func, over = c(1, 2), nover = 5, nover1 = nover,
  nover2 = nover, low = rep(0, 4), high = rep(1, 4),
  same_scale = TRUE, n = 20, batchmax = 1,
  var_names = c(expression(), lapply(1:4, function(ti)
  bquote(x[.(ti)]))), pts = NULL, axes = TRUE, key.axes, key.title,
  nlevels = 20, color.palette = cm.colors.strong, edge_width = 0.04,
  cex.var_names = 1.3, bar = TRUE, bar_width = 0.2, over_srt = c(0,
  90), ...)
}
\arguments{
\item{func}{A four-dimensional function to plot contours of}

\item{over}{Indices of the dimensions used for the outer grid}

\item{nover}{Number of grid points for the outer grid dimensions}

\item{nover1}{Number of grid points for the first outer grid dimension}

\item{nover2}{Number of grid points for the second outer grid dimension}

\item{low}{Low input value for each dimension}

\item{high}{High input value for each dimension}

\item{same_scale}{Should all contour plots be on the same scale?
Takes longer since it has to precalculate range of outputs.}

\item{n}{Number of points in grid on each dimension}

\item{batchmax}{number of datapoints that can be computed at a time}

\item{var_names}{Variable names to add to plot}

\item{pts}{Matrix of points to show on plot}

\item{axes}{axes}

\item{key.axes}{key for bar plot}

\item{key.title}{statements which add titles for the plot key.}

\item{nlevels}{Number of levels in contour scale}

\item{color.palette}{Color palette used for contour plots}

\item{edge_width}{How wide should edges with variable names be?
As proportion of screen section to left of bar.
Either single value for both edges, or length two vector.}

\item{cex.var_names}{Size of var_names printed on edges.}

\item{bar}{Should a bar be added on right when all on same_scale?}

\item{bar_width}{How wide should bar section of plot be?}

\item{over_srt}{Degrees of rotation for the axis labels. Vector of length two.}

\item{...}{Arguments passed to cf_func, and then probably through to cf_grid}
}
\description{
Plots a grid of contour plots.
Each contour plot is a contour over two dimensions with the remaining
two dimensions set to a value.
See cf_highdim for functions with more than 4 dimensions.
}
\examples{
cf_4dim(
  function(x) {x[1] + x[2]^2 + sin(2*pi*x[3])}
)

cf_4dim(function(x) x[1]*x[3] + sin(x[2]*x[4]), color.palette=heat.colors,
        nover1=3, nover2=8, cex.var_names = .5)
        
cf_4dim(function(x) x[1]*x[3] + sin(x[2]*x[4]), color.palette=topo.colors,
        nover1=3, nover2=8, cex.var_names = 1, over_srt = c(90,0),
        edge_width=c(.1, .2), nlevels = 5)
}
