% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulaterows.R
\name{tabulaterows}
\alias{tabulaterows}
\title{Frequency distribution of a sample of rankings}
\usage{
tabulaterows(X, miss = FALSE)
}
\arguments{
\item{X}{a N by M data matrix containing N judges judging M objects}

\item{miss}{TRUE if there are missing data (either partial or incomplete rankings): default: FALSE}
}
\value{
a "list" containing the following components:
\tabular{lll}{
X \tab  \tab the unique rankings\cr
Wk \tab       \tab the frequency associated to each ranking\cr
tabfreq\tab   \tab frequency table}
}
\description{
Given a sample of preference rankings, it compute the frequency associated to each ranking
}
\examples{
data(Idea)
TR<-tabulaterows(Idea)
FR<-TR$Wk/sum(TR$Wk)
RF<-cbind(TR$X,FR)
colnames(RF)<-c(colnames(Idea),"fi")
#compute modal ranking
maxfreq<-which(RF[,6]==max(RF[,6]))
rank2order(RF[maxfreq,1:5],items=colnames(Idea))
#
data(APAred)
TR<-tabulaterows(APAred)
#
data(APAFULL)
TR<-tabulaterows(APAFULL)
CR1<-consrank(TR$X,wk=TR$Wk)
CR2<-consrank(TR$X,wk=TR$Wk,algorithm="fast",itermax=15)
CR3<-consrank(TR$X,wk=TR$Wk,algorithm="quick")

}
\author{
Antonio D'Ambrosio \email{antdambr@unina.it}
}
\keyword{frequency}
\keyword{of}
\keyword{rankings}
\keyword{table}
