% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FEVD.R
\name{FEVD}
\alias{FEVD}
\title{Forecast error variance decomposition}
\usage{
FEVD(
  Phi,
  Sigma,
  nfore = 100,
  type = c("time", "frequency"),
  generalized = TRUE,
  range = NULL
)
}
\arguments{
\item{Phi}{VAR coefficient matrix}

\item{Sigma}{Residual variance-covariance matrix}

\item{nfore}{H-step ahead forecast horizon}

\item{type}{Time or Frequency connectedness approach}

\item{generalized}{Generalized or orthogonalized FEVD}

\item{range}{Partition range for frequency approach only.}
}
\value{
Orthogonalized/generalized time/frequency forecast error variance decomposition
}
\description{
This function computes the orthogonalized/generalized forecast error variance decomposition
}
\examples{
data(dy2012)
fit = VAR(dy2012, configuration=list(nlag=1))
fevd = FEVD(Phi=fit$B, Sigma=fit$Q, nfore=10, type="time", generalized=TRUE)$FEVD
}
\references{
Stiassny, A. (1996). A spectral decomposition for structural VAR models. Empirical Economics, 21(4), 535-555.

Koop, G., Pesaran, M. H., & Potter, S. M. (1996). Impulse response analysis in nonlinear multivariate models. Journal of Econometrics, 74(1), 119-147.

Pesaran, H. H., & Shin, Y. (1998). Generalized impulse response analysis in linear multivariate models. Economics Letters, 58(1), 17-29.
}
