/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.propertymap;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import net.infonode.properties.base.Property;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapListener;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.util.PropertyChangeListener;

public class PropertyMapWeakListenerManager {
    private static WeakHashMap listenerMap = new WeakHashMap();
    private static WeakHashMap propertyChangeListenerMap = new WeakHashMap();
    private static WeakHashMap treeListenerMap = new WeakHashMap();
    private static ReferenceQueue refQueue = new ReferenceQueue();
    private static ListenerRef ref;
    private static Runnable refRemover;

    private PropertyMapWeakListenerManager() {
    }

    private static void addToMap(WeakHashMap weakHashMap, Object object, Object object2) {
        ArrayList<Object> arrayList = (ArrayList<Object>)weakHashMap.get(object);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>(2);
            weakHashMap.put(object, arrayList);
        }
        arrayList.add(object2);
    }

    private static void removeFromMap(WeakHashMap weakHashMap, Object object, PropertyMap propertyMap) {
        ArrayList arrayList = (ArrayList)weakHashMap.get(object);
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ListenerRef listenerRef = (ListenerRef)arrayList.get(i);
                if (listenerRef.getMap() != propertyMap) continue;
                listenerRef.removeFromMap();
                arrayList.remove(i);
                if (arrayList.size() == 0) {
                    weakHashMap.remove(object);
                }
                return;
            }
        }
    }

    private static void removeFromMap(WeakHashMap weakHashMap, Object object, PropertyMap propertyMap, Property property) {
        ArrayList arrayList = (ArrayList)weakHashMap.get(object);
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                PropertyChangeListenerRef propertyChangeListenerRef = (PropertyChangeListenerRef)arrayList.get(i);
                if (propertyChangeListenerRef.getMap() != propertyMap || propertyChangeListenerRef.getProperty() != property) continue;
                propertyChangeListenerRef.removeFromMap();
                arrayList.remove(i);
                if (arrayList.size() == 0) {
                    weakHashMap.remove(object);
                }
                return;
            }
        }
    }

    public static void addWeakListener(PropertyMap propertyMap, PropertyMapListener propertyMapListener) {
        MapListenerRef mapListenerRef = new MapListenerRef(propertyMapListener, refQueue, propertyMap);
        PropertyMapWeakListenerManager.addToMap(listenerMap, propertyMapListener, mapListenerRef);
    }

    public static void addWeakPropertyChangeListener(PropertyMap propertyMap, Property property, PropertyChangeListener propertyChangeListener) {
        PropertyChangeListenerRef propertyChangeListenerRef = new PropertyChangeListenerRef(propertyChangeListener, refQueue, propertyMap, property);
        PropertyMapWeakListenerManager.addToMap(propertyChangeListenerMap, propertyChangeListener, propertyChangeListenerRef);
    }

    public static void addWeakTreeListener(PropertyMap propertyMap, PropertyMapTreeListener propertyMapTreeListener) {
        TreeListenerRef treeListenerRef = new TreeListenerRef(propertyMapTreeListener, refQueue, propertyMap);
        PropertyMapWeakListenerManager.addToMap(treeListenerMap, propertyMapTreeListener, treeListenerRef);
    }

    public static void removeWeakListener(PropertyMap propertyMap, PropertyMapListener propertyMapListener) {
        PropertyMapWeakListenerManager.removeFromMap(listenerMap, propertyMapListener, propertyMap);
    }

    public static void removeWeakPropertyChangeListener(PropertyMap propertyMap, Property property, PropertyChangeListener propertyChangeListener) {
        PropertyMapWeakListenerManager.removeFromMap(propertyChangeListenerMap, propertyChangeListener, propertyMap, property);
    }

    public static void removeWeakTreeListener(PropertyMap propertyMap, PropertyMapTreeListener propertyMapTreeListener) {
        PropertyMapWeakListenerManager.removeFromMap(treeListenerMap, propertyMapTreeListener, propertyMap);
    }

    static {
        refRemover = new Runnable(){

            public void run() {
                while (ref != null) {
                    ref.removeFromMap();
                    ref = (ListenerRef)refQueue.poll();
                }
            }
        };
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        ref = (ListenerRef)refQueue.remove();
                        SwingUtilities.invokeAndWait(refRemover);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    private static class TreeListenerRef
    extends ListenerRef
    implements PropertyMapTreeListener {
        TreeListenerRef(PropertyMapTreeListener propertyMapTreeListener, ReferenceQueue referenceQueue, PropertyMap propertyMap) {
            super(propertyMapTreeListener, referenceQueue, propertyMap);
            propertyMap.addTreeListener(this);
        }

        public void removeFromMap() {
            this.getMap().removeTreeListener(this);
            super.removeFromMap();
        }

        public void propertyValuesChanged(Map map) {
            PropertyMapTreeListener propertyMapTreeListener = (PropertyMapTreeListener)this.get();
            if (propertyMapTreeListener != null) {
                propertyMapTreeListener.propertyValuesChanged(map);
            }
        }
    }

    private static class PropertyChangeListenerRef
    extends ListenerRef
    implements PropertyChangeListener {
        private Property property;

        PropertyChangeListenerRef(PropertyChangeListener propertyChangeListener, ReferenceQueue referenceQueue, PropertyMap propertyMap, Property property) {
            super(propertyChangeListener, referenceQueue, propertyMap);
            this.property = property;
            propertyMap.addPropertyChangeListener(property, this);
        }

        public Property getProperty() {
            return this.property;
        }

        public void removeFromMap() {
            this.getMap().removePropertyChangeListener(this.property, this);
            super.removeFromMap();
        }

        public void propertyChanged(Property property, Object object, Object object2, Object object3) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.get();
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChanged(property, object, object2, object3);
            }
        }
    }

    private static class MapListenerRef
    extends ListenerRef
    implements PropertyMapListener {
        MapListenerRef(PropertyMapListener propertyMapListener, ReferenceQueue referenceQueue, PropertyMap propertyMap) {
            super(propertyMapListener, referenceQueue, propertyMap);
            propertyMap.addListener(this);
        }

        public void removeFromMap() {
            this.getMap().removeListener(this);
            super.removeFromMap();
        }

        public void propertyValuesChanged(PropertyMap propertyMap, Map map) {
            PropertyMapListener propertyMapListener = (PropertyMapListener)this.get();
            if (propertyMapListener != null) {
                propertyMapListener.propertyValuesChanged(propertyMap, map);
            }
        }
    }

    private static class ListenerRef
    extends WeakReference {
        private PropertyMap map;

        protected ListenerRef(Object object, ReferenceQueue referenceQueue, PropertyMap propertyMap) {
            super(object, referenceQueue);
            this.map = propertyMap;
        }

        public PropertyMap getMap() {
            return this.map;
        }

        public void removeFromMap() {
            this.map = null;
        }
    }
}

