/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.gui.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.panel.BaseContainer;
import net.infonode.gui.panel.BaseContainerUtil;
import net.infonode.properties.base.PropertyGroup;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapContainer;
import net.infonode.properties.propertymap.PropertyMapFactory;
import net.infonode.properties.propertymap.PropertyMapGroup;
import net.infonode.properties.propertymap.PropertyMapValueHandler;
import net.infonode.properties.types.BorderProperty;
import net.infonode.properties.types.ColorProperty;
import net.infonode.properties.types.FontProperty;
import net.infonode.properties.types.InsetsProperty;
import net.infonode.util.Direction;

public class ComponentProperties
extends PropertyMapContainer {
    public static final PropertyMapGroup PROPERTIES = new PropertyMapGroup("Component Properties", "");
    public static final BorderProperty BORDER = new BorderProperty((PropertyGroup)PROPERTIES, "Border", "Component border.", PropertyMapValueHandler.INSTANCE);
    public static final InsetsProperty INSETS = new InsetsProperty((PropertyGroup)PROPERTIES, "Insets", "Component insets inside the border.", PropertyMapValueHandler.INSTANCE);
    public static final ColorProperty FOREGROUND_COLOR = new ColorProperty((PropertyGroup)PROPERTIES, "Foreground Color", "Component foreground color.", PropertyMapValueHandler.INSTANCE);
    public static final FontProperty FONT = new FontProperty((PropertyGroup)PROPERTIES, "Font", "Component text font.", PropertyMapValueHandler.INSTANCE);
    public static final ColorProperty BACKGROUND_COLOR = new ColorProperty((PropertyGroup)PROPERTIES, "Background Color", "Component background color. A null value means that no background will be painted.", PropertyMapValueHandler.INSTANCE);

    public ComponentProperties() {
        super(PROPERTIES);
    }

    public ComponentProperties(PropertyMap propertyMap) {
        super(propertyMap);
    }

    public ComponentProperties(ComponentProperties componentProperties) {
        super(PropertyMapFactory.create(componentProperties.getMap()));
    }

    public ComponentProperties addSuperObject(ComponentProperties componentProperties) {
        this.getMap().addSuperMap(componentProperties.getMap());
        return this;
    }

    public ComponentProperties removeSuperObject() {
        this.getMap().removeSuperMap();
        return this;
    }

    public ComponentProperties removeSuperObject(ComponentProperties componentProperties) {
        this.getMap().removeSuperMap(componentProperties.getMap());
        return this;
    }

    public ComponentProperties setBorder(Border border) {
        BORDER.set(this.getMap(), border);
        return this;
    }

    public ComponentProperties setInsets(Insets insets) {
        INSETS.set(this.getMap(), insets);
        return this;
    }

    public ComponentProperties setBackgroundColor(Color color) {
        BACKGROUND_COLOR.set(this.getMap(), color);
        return this;
    }

    public Insets getInsets() {
        return INSETS.get(this.getMap());
    }

    public Border getBorder() {
        return BORDER.get(this.getMap());
    }

    public Color getBackgroundColor() {
        return BACKGROUND_COLOR.get(this.getMap());
    }

    public Font getFont() {
        return FONT.get(this.getMap());
    }

    public Color getForegroundColor() {
        return FOREGROUND_COLOR.get(this.getMap());
    }

    public ComponentProperties setForegroundColor(Color color) {
        FOREGROUND_COLOR.set(this.getMap(), color);
        return this;
    }

    public ComponentProperties setFont(Font font) {
        FONT.set(this.getMap(), font);
        return this;
    }

    public void applyTo(JComponent jComponent) {
        this.applyTo(jComponent, Direction.RIGHT);
    }

    public void applyTo(JComponent jComponent, Direction direction) {
        EmptyBorder emptyBorder;
        Insets insets = this.getInsets() == null ? null : InsetsUtil.rotate(direction, this.getInsets());
        EmptyBorder emptyBorder2 = emptyBorder = insets == null ? null : new EmptyBorder(insets);
        jComponent.setBorder(this.getBorder() == null ? emptyBorder : (emptyBorder == null ? this.getBorder() : new CompoundBorder(this.getBorder(), emptyBorder)));
        if (jComponent instanceof BaseContainer) {
            BaseContainer baseContainer = (BaseContainer)jComponent;
            BaseContainerUtil.setOverridedBackground(baseContainer, this.getBackgroundColor());
            BaseContainerUtil.setOverridedForeground(baseContainer, this.getForegroundColor());
            BaseContainerUtil.setOverridedFont(baseContainer, this.getFont());
        } else {
            jComponent.setBackground(this.getBackgroundColor());
            jComponent.setFont(this.getFont());
            jComponent.setForeground(this.getForegroundColor());
        }
    }

    static {
        ComponentProperties componentProperties = new ComponentProperties(PROPERTIES.getDefaultMap());
        componentProperties.setBackgroundColor(null).setBorder(null).setInsets(null);
    }
}

