% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cox_Regression.R
\name{RunCoxNull}
\alias{RunCoxNull}
\title{Performs basic Cox Proportional Hazards regression with the null model}
\usage{
RunCoxNull(
  df,
  time1 = "start",
  time2 = "end",
  event0 = "event",
  control = list()
)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{time1}{column used for time period starts}

\item{time2}{column used for time period end}

\item{event0}{column used for event status}

\item{control}{list of parameters controlling the convergence, see Def_Control() for options or vignette("Control_Options")}
}
\value{
returns a list of the final results
}
\description{
\code{RunCoxRegression} uses user provided data and time/event columns
to calculate the log-likelihood with constant hazard ratio
}
\examples{
library(data.table)
## basic example code reproduced from the starting-description vignette
df <- data.table::data.table(
  "UserID" = c(112, 114, 213, 214, 115, 116, 117),
  "Starting_Age" = c(18, 20, 18, 19, 21, 20, 18),
  "Ending_Age" = c(30, 45, 57, 47, 36, 60, 55),
  "Cancer_Status" = c(0, 0, 1, 0, 1, 0, 0)
)
# For the interval case
time1 <- "Starting_Age"
time2 <- "Ending_Age"
event <- "Cancer_Status"
control <- list(
  "ncores" = 2, "verbose" = FALSE, "ties" = "breslow",
  "double_step" = 1
)
e <- RunCoxNull(df, time1, time2, event, control)

}
\seealso{
Other Cox Wrapper Functions: 
\code{\link{RunCoxRegression}()},
\code{\link{RunCoxRegression_Basic}()},
\code{\link{RunCoxRegression_CR}()},
\code{\link{RunCoxRegression_Guesses_CPP}()},
\code{\link{RunCoxRegression_Omnibus}()},
\code{\link{RunCoxRegression_Omnibus_Multidose}()},
\code{\link{RunCoxRegression_STRATA}()},
\code{\link{RunCoxRegression_Single}()},
\code{\link{RunCoxRegression_Tier_Guesses}()}
}
\concept{Cox Wrapper Functions}
