% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{Correct_Formula_Order}
\alias{Correct_Formula_Order}
\title{Corrects the order of terms/formula/etc}
\usage{
Correct_Formula_Order(
  term_n,
  tform,
  keep_constant,
  a_n,
  names,
  der_iden = 0,
  cons_mat = matrix(c(0)),
  cons_vec = c(0),
  verbose = FALSE,
  model_control = list()
)
}
\arguments{
\item{term_n}{term numbers for each element of the model}

\item{tform}{list of string function identifiers, used for linear/step}

\item{keep_constant}{binary values to denote which parameters to change}

\item{a_n}{list of initial parameter values, used to determine number of parameters. May be either a list of vectors or a single vector.}

\item{names}{columns for elements of the model, used to identify data columns}

\item{der_iden}{number for the subterm to test derivative at, only used for testing runs with a single varying parameter, should be smaller than total number of parameters. indexed starting at 0}

\item{cons_mat}{Matrix containing coefficients for system of linear constraints, formatted as matrix}

\item{cons_vec}{Vector containing constants for system of linear constraints, formatted as vector}

\item{verbose}{integer valued 0-4 controlling what information is printed to the terminal. Each level includes the lower levels. 0: silent, 1: errors printed, 2: warnings printed, 3: notes printed, 4: debug information printed. Errors are situations that stop the regression, warnings are situations that assume default values that the user might not have intended, notes provide information on regression progress, and debug prints out C++ progress and intermediate results. The default level is 2 and True/False is converted to 3/0.}

\item{model_control}{controls which alternative model options are used, see Def_model_control() for options and vignette("Control_Options") for further details}
}
\value{
returns the corrected lists
}
\description{
\code{Correct_Formula_Order} checks the order of formulas given and corrects any ordering issues, orders alphabetically, by term number, etc.
}
\examples{
library(data.table)
## basic example code reproduced from the starting-description vignette
term_n <- c(0, 1, 1, 0, 0)
tform <- c("loglin", "quad_slope", "lin", "lin_int", "lin_slope")
keep_constant <- c(0, 0, 0, 1, 0)
a_n <- c(1, 2, 3, 4, 5)
names <- c("a", "a", "a", "a", "a")
val <- Correct_Formula_Order(term_n, tform, keep_constant,
  a_n, names,
  cons_mat = matrix(c(0)),
  cons_vec = c(0)
)
term_n <- val$term_n
tform <- val$tform
keep_constant <- val$keep_constant
a_n <- val$a_n
der_iden <- val$der_iden
names <- val$names

}
\seealso{
Other Data Cleaning Functions: 
\code{\link{Check_Dupe_Columns}()},
\code{\link{Check_Trunc}()},
\code{\link{Check_Verbose}()},
\code{\link{Date_Shift}()},
\code{\link{Def_Control}()},
\code{\link{Def_Control_Guess}()},
\code{\link{Def_model_control}()},
\code{\link{Def_modelform_fix}()},
\code{\link{Joint_Multiple_Events}()},
\code{\link{Replace_Missing}()},
\code{\link{Time_Since}()},
\code{\link{factorize}()},
\code{\link{factorize_par}()},
\code{\link{gen_time_dep}()},
\code{\link{interact_them}()}
}
\concept{Data Cleaning Functions}
