% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Make_Groups_STRATA}
\alias{Make_Groups_STRATA}
\title{Utility function to define risk groups with STRATA
\code{Make_Groups_STRATA} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group}
\usage{
Make_Groups_STRATA(
  ntime,
  df_m,
  RiskFail,
  RiskGroup,
  tu,
  nthreads,
  debugging,
  STRATA_vals
)
}
\arguments{
\item{ntime}{number of risk groups}

\item{df_m}{event/time matrix}

\item{RiskFail}{matrix of indexes for event rows in each risk group}

\item{RiskGroup}{list of string indices for every risk group}

\item{tu}{Event time vector}

\item{nthreads}{number of threads available}

\item{debugging}{additional boolean for verbosity in testing}

\item{STRATA_vals}{vector of strata identifier values}
}
\value{
Updates matrices in place: Matrix of event rows for each event time, vectors of strings with rows at risk for each event time
}
\description{
Utility function to define risk groups with STRATA
\code{Make_Groups_STRATA} Called to update lists of risk groups, Uses list of event times and row time/event information, Matrices store starting/stopping row indices for each group
}
