% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Cox_Term_Risk_Calc}
\alias{Cox_Term_Risk_Calc}
\title{Utility function to perform calculation of terms and risks for Cox Omnibus
\code{Cox_Term_Risk_Calc} Called to perform repeated term and risk calculations}
\usage{
Cox_Term_Risk_Calc(
  modelform,
  tform,
  Term_n,
  totalnum,
  fir,
  dfc,
  term_tot,
  T0,
  Td0,
  Tdd0,
  Te,
  R,
  Rd,
  Rdd,
  Dose,
  nonDose,
  beta_0,
  df0,
  dint,
  dslp,
  TTerm,
  nonDose_LIN,
  nonDose_PLIN,
  nonDose_LOGLIN,
  RdR,
  RddR,
  nthreads,
  debugging,
  KeepConstant,
  verbose,
  basic_bool,
  single_bool,
  start,
  gmix_theta,
  gmix_term
)
}
\arguments{
\item{modelform}{string model identifier}

\item{tform}{subterm types}

\item{Term_n}{Term numbers}

\item{totalnum}{total number of parameters}

\item{fir}{st term number}

\item{dfc}{vector matching subterm number to matrix column}

\item{term_tot}{total number of terms}

\item{T0}{Term value for each subterm}

\item{Td0}{Term by subterm derivative matrix}

\item{Tdd0}{Term by subterm second derivative matrix}

\item{Te}{temporary term storage matrix}

\item{R}{risk vector}

\item{Rd}{Risk first derivative matrix}

\item{Rdd}{Risk second derivative matrix}

\item{Dose}{term matrix}

\item{nonDose}{term matrix}

\item{beta_0}{parameter estimates}

\item{df0}{matrix of covariate values}

\item{dint}{value used for threshold derivative finite step}

\item{dslp}{value used for slope derivative finite step}

\item{TTerm}{Total term matrix}

\item{nonDose_LIN}{Linear term matrix}

\item{nonDose_PLIN}{Product linear term matrix}

\item{nonDose_LOGLIN}{Loglinear term matrix}

\item{RdR}{Risk to first derivative ratio matrix}

\item{RddR}{Risk to second derivative ratio matrix}

\item{nthreads}{number of threads available}

\item{debugging}{additional boolean for verbosity in testing}

\item{KeepConstant}{binary vector to identify constant parameters}

\item{verbose}{boolean for additional printing}

\item{basic_bool}{boolean for multiplicative log-linear model}

\item{single_bool}{boolean for single calculation without derivatives}

\item{start}{starting time for regression}

\item{gmix_theta}{theta value for geometric-mixture model}

\item{gmix_term}{list of 0/1 to identify which terms to set as Relative Risk (0) or Excess Risk (1)}
}
\value{
Updates matrices in place: risk storage matrices
}
\description{
Utility function to perform calculation of terms and risks for Cox Omnibus
\code{Cox_Term_Risk_Calc} Called to perform repeated term and risk calculations
}
