% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableCharacteristics.R
\name{tableCharacteristics}
\alias{tableCharacteristics}
\title{Format a summarise_characteristics object into a visual table.}
\usage{
tableCharacteristics(
  result,
  type = "gt",
  header = c("cdm_name", "cohort_name"),
  groupColumn = character(),
  hide = c(additionalColumns(result), settingsColumns(result))
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{header}{Columns to use as header. See options with
\code{availableTableColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{availableTableColumns(result)}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{availableTableColumns(result)}.}
}
\value{
A formatted table.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(CohortCharacteristics)

cdm <- mockCohortCharacteristics()

result <- summariseCharacteristics(cdm$cohort1)

tableCharacteristics(result)

mockDisconnect(cdm)
}

}
