% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseOrphanCodes.R
\name{summariseOrphanCodes}
\alias{summariseOrphanCodes}
\title{Find orphan codes related to a codelist using achilles counts and, if
available, PHOEBE concept recommendations}
\usage{
summariseOrphanCodes(
  x,
  cdm,
  domain = c("condition", "device", "drug", "measurement", "observation", "procedure",
    "visit")
)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference via CDMConnector.}

\item{domain}{Character vector with one or more of the OMOP CDM domains.
The results will be restricted to the given domains. Check the available
ones by running getDomains(). If NULL, all supported domains are included:
Condition, Drug, Procedure, Device, Observation, and Measurement.}
}
\value{
A summarised result containg the frequency of codes related
to (but not in) the codelist.
}
\description{
Find orphan codes related to a codelist using achilles counts and, if
available, PHOEBE concept recommendations
}
\examples{
\donttest{
cdm <- mockVocabRef("database")
codes <- getCandidateCodes(cdm = cdm,
keywords = "Musculoskeletal disorder",
domains = "Condition",
includeDescendants = FALSE)

orphan_codes <- summariseOrphanCodes(x = list("msk" = codes$concept_id),
cdm = cdm)

orphan_codes
CDMConnector::cdmDisconnect(cdm)
}
}
