% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetOnRouteCategory.R
\name{subsetOnRouteCategory}
\alias{subsetOnRouteCategory}
\title{Subset a codelist to only those with a particular route category}
\usage{
subsetOnRouteCategory(x, cdm, routeCategory, negate = FALSE)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference via CDMConnector.}

\item{routeCategory}{Only codes with the specified route will be
returned. If NULL, descendant codes will be returned regardless of route
category. Use getRoutes() to find the available route categories.}

\item{negate}{If FALSE, only concepts with the routeCategory specified will
be returned. If TRUE, concepts with the routeCategory specified will be excluded.}
}
\value{
The codelist with only those concepts associated with the
specified route categories (if negate is FALSE) or the codelist without those
concepts associated with the specified route categories (if negate is TRUE).
}
\description{
Subset a codelist to only those with a particular route category
}
\examples{
\donttest{
library(CodelistGenerator)
cdm <- mockVocabRef()
codes <- subsetOnRouteCategory(
              x = list("codes" = c(20,21)),
              cdm = cdm,
              routeCategory = "topical")
codes
}
}
