% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugCodes.R
\name{getATCCodes}
\alias{getATCCodes}
\title{Get descendant codes for ATC levels}
\usage{
getATCCodes(
  cdm,
  level = c("ATC 1st"),
  name = NULL,
  doseForm = NULL,
  withConceptDetails = FALSE
)
}
\arguments{
\item{cdm}{cdm_reference via CDMConnector}

\item{level}{ATC level. Can be one or more of "ATC 1st", "ATC 2nd",
"ATC 3rd", "ATC 4th", and "ATC 5th"}

\item{name}{ATC name of interest. For example, c("Dermatologicals",
"Nervous System"), would result in a list of length two with the descendant
concepts for these two particular ATC groups.}

\item{doseForm}{Only descendants codes with the specified dose form
will be returned. If NULL, descendant codes will be returned regardless
of dose form.}

\item{withConceptDetails}{If FALSE, each item in the list of results (one per
ATC group) will contain a vector of concept IDs for each ingredient. If
TRUE each item in the list of results will contain a tibble with additional
information on the identified concepts.}
}
\value{
A named list, with each item containing a vector of descendant
concepts of an ATC group (if withConceptDetails was set as FALSE) or a
tibble with the descendant concepts along with additional details about them
(if withConceptDetails was set as TRUE).
}
\description{
Get descendant codes for ATC levels
}
\examples{
\dontrun{
cdm <- mockVocabRef()
getATCCodes(cdm = cdm, level = "ATC 1st")
CDMConnector::cdmDisconnect(cdm)
}
}
