% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stcs.r
\name{stcs}
\alias{stcs}
\title{SpatioTemporal Correlation Structure}
\usage{
stcs(id, ...)
}
\arguments{
\item{id}{spatiotemporal correlation structure ID}

\item{...}{additional arguments (t as time lag, s as spatial lag (distance),  and stcs parameters)}
}
\description{
Provides a parametric function that describes the values of the linear spatiotemporal autocorrelation up to desired lags. For more details on the parametric spatiotemporal correlation structures see section 2.3 and 2.4 in \href{https://doi.org/10.1029/2019WR026331}{Papalexiou and Serinaldi (2020)}
}
\examples{

library(CoSMoS)
library(plotly)

## specify grid of spatial and temporal lags
d <- 31
st <- expand.grid(0:(d-1),
                  0:(d-1))

## get the STCS
wc <- stcs("clayton",
           t = st[, 1],
           s = st[, 2],
           scfid = 'weibull',
           tcfid = 'weibull',
           copulaarg = 2,
           scfarg = list(scale = 20,
                         shape = 0.7),
           tcfarg = list(scale = 1.1,
                         shape = 0.8))

g14 <- stcs("gneiting14",
            t = st[, 1],
            s = st[, 2],
            a = 1/50,
            c = 1/10,
            alpha = 1,
            beta = 1,
            gamma = 0.5,
            tau = 1)

g16 <- stcs("gneiting16",
            t = st[, 1],
            s = st[, 2],
            a = 1/50,
            c = 1/10,
            alpha = 1,
            beta = 1,
            nu = 0.5,
            tau = 1)

## note: for nu = 0.5 stcfgneiting16 is equivalent to
## stcfgneiting14 with gamma = 0.5

## visualize the STCS

wc.m <- matrix(wc,
               nrow = d)

plot_ly(z = ~wc.m) \%>\%
    add_surface() \%>\%
    layout(
        scene = list(
            xaxis = list(title = "Time lag"),
            yaxis = list(title = "Distance"),
            zaxis = list(title = "STCF")
        )
    ) \%>\%
    hide_colorbar()

g14.m <- matrix(g14,
                nrow = d)

plot_ly(z = ~g14.m) \%>\%
    add_surface() \%>\%
    layout(
        scene = list(
            xaxis = list(title = "Time lag"),
            yaxis = list(title = "Distance"),
            zaxis = list(title = "STCF")
        )
    ) \%>\%
    hide_colorbar()

}
