% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acti.R
\name{actpnts}
\alias{actpnts}
\title{AutoCorrelation Transformed Points}
\usage{
actpnts(margdist, margarg, p0 = 0, distbounds = c(-Inf, Inf))
}
\arguments{
\item{margdist}{target marginal distribution}

\item{margarg}{list of marginal distribution arguments}

\item{p0}{probability zero}

\item{distbounds}{distribution bounds (default set to c(-Inf, Inf))}
}
\description{
Transforms a gaussian process in order to match a target marginal lowers its autocorrelation values. The actpnts evaluates the corresponding autocorrelations for the given target marginal for a set of gaussian correlations, i.e., it returns  (\eqn{\rho_x , \rho_z}) points where \eqn{\rho_x and \rho_z} represent, respectively, the autocorrelations of the target and gaussian process.
}
\examples{

library(CoSMoS)

## here we target to a process that has the Pareto type II marginal distribution
## with scale parameter 1 and shape parameter 0.3
## (note that all parameters have to be named)
dist <- 'paretoII'
distarg <- list(scale = 1, shape = .3)

x <- actpnts(margdist = dist, margarg = distarg, p0 = 0)
x

## you can see the points by using
ggplot(x,
       aes(x = rhox,
           y = rhoz)) +
  geom_point(colour = 'royalblue4', size = 2.5) +
  geom_abline(lty = 5) +
  labs(x = bquote(Autocorrelation ~ rho[x]),
       y = bquote(Gaussian ~ rho[z])) +
  scale_x_continuous(limits = c(0, 1)) +
  scale_y_continuous(limits = c(0, 1)) +
  theme_classic()

}
