% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_generic.R
\name{add.risk}
\alias{add.risk}
\title{Additional risk function}
\usage{
add.risk(y, x, fit, mcmc, a, alpha=0.05, 
x.grid=NULL, y.grid=NULL)
}
\arguments{
\item{y}{optional numeric vector for the response used in \code{comire.gibbs}. If \code{y} is missing, \code{y.grid} must be provided.}

\item{x}{numeric vector for the covariate relative to the dose of exposure used in \code{comire.gibbs}.}

\item{fit}{the output of \code{comire.gibbs}. an object of the class \code{classCoMiRe}.}

\item{mcmc}{a list giving the MCMC parameters.}

\item{a}{threshold of clinical interest for the response variable}

\item{alpha}{level of the credible bands.}

\item{x.grid}{optional numerical vector giving the actual values of the grid for x for plotting the additional risk function. If \eqn{x.gird} is not provided, standard grids are automatically used.}

\item{y.grid}{optional numerical vector giving the actual values of the grid for y for plotting the additional risk function. If \eqn{y.gird} is not provided, standard grids are automatically used.}
}
\value{
A list of arguments for generating posterior output. It contains:
\itemize{
\item{\code{mcmc.risk}}{ a matrix containing in the lines the MCMC chains, after thinning, of the additional risk function over \code{x.grid}, in the columns. }
\item{\code{summary.risk}}{ a data frame with four variables: the posterior means of the additional risk function over \code{x.grid}, the respective \eqn{\alpha/2} and \eqn{1-\alpha/2} quantiles, and \code{x.grid}.}
}
}
\description{
Additional risk function estimated from the object \code{fit}
}
\examples{
{
data(CPP)
attach(CPP)

n <- NROW(CPP)
J <- H <- 10

premature <- as.numeric(gestage<=37)

mcmc <- list(nrep=5000, nb=2000, thin=5, ndisplay=4)

## too few iterations to be meaningful. see below for safer and more comprehensive results

mcmc <- list(nrep=10, nb=2, thin=1, ndisplay=4) 

prior <- list(mu.theta=mean(gestage), k.theta=10, eta=rep(1, J)/J, 
              alpha=rep(1,H)/H, a=2, b=2, J=J, H=H)
              
fit.dummy <- comire.gibbs(gestage, dde, family="continuous", 
                     mcmc=mcmc, prior=prior, seed=1, max.x=180)
                     
risk.data <- add.risk(y = gestage, x = dde, fit = fit.dummy, mcmc = mcmc, 
    a = 37, x.grid = seq(0, max(dde), length = 100))
riskplot(risk.data$summary.risk, xlab="DDE", x = dde, xlim = c(0,150))
                    
\donttest{
## safer procedure with more iterations (it may take some time)

mcmc <- list(nrep=5000, nb=2000, thin=5, ndisplay=4)

## Fit the model for continuous y 

prior <- list(mu.theta=mean(gestage), k.theta=10, eta=rep(1, J)/J, 
              alpha=rep(1,H)/H, a=2, b=2, J=J, H=H)
              
fit1 <- comire.gibbs(gestage, dde, family="continuous", 
                     mcmc=mcmc, prior=prior, seed=5, max.x=180)
 
risk.data <- add.risk(y = gestage, x = dde, fit = fit1, mcmc = mcmc, 
a = 37, x.grid = seq(0, max(dde), length = 100))
riskplot(risk.data$summary.risk, xlab="DDE", x = dde, xlim = c(0,150))

}
}
}
\author{
Antonio Canale, Arianna Falcioni
}
