% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionBPBM.R
\name{PredictionBPBM}
\alias{PredictionBPBM}
\title{Predicting using BPBM}
\usage{
PredictionBPBM(
  NumSPBal,
  DemSPBal,
  MCMC.CHAINS,
  alpha,
  K,
  esperanza,
  Var,
  E,
  Tt,
  MatrizPBmodelo
)
}
\arguments{
\item{NumSPBal}{List. The component i of the list has the number of the row of the matrix \code{especie} where the bacteria in the numerator of the principal balance i are placed.}

\item{DemSPBal}{List. The component i of the list has the number of the row of the matrix \code{especie} where the bacteria in the denominator of the principal balance i are placed.}

\item{MCMC.CHAINS}{Matrix with the iterations of all the chains for all the parameters. Each column has all the iteration of one parameter. If the cero is in the center of the credible interval of one parameter all its iteration in the Marchov Chain have the value 0. It is output of the "StudyingParam" function adding "$AllChainsJoined".}

\item{alpha}{Matrix that contains at the row i the Dirichlet parameter of the bacteria i at t=1,2,3,...,\code{Tt}.}

\item{K}{Number. The function will calculate the value of the expected value and the variance at \code{Tt} and predict for the time points t=\code{Tt}+1,..,K. To predict all the time points available at the data we K=dim(especie.All)-1}

\item{esperanza}{Matrix that contains at row i the expected value of the bacterial taxa of bacteria i at t=1,2,3,...,\code{Tt}-1.}

\item{Var}{Matrix that contains at row i the variance of the bacterial taxa of bacteria i at t=1,2,3,...,\code{Tt}-1.}

\item{E}{Number of bacteria available}

\item{Tt}{Number of bacteria available}

\item{MatrizPBmodelo}{is the matrix that contains the covariates of the model. The first line es equal to 1 for all columns. The other rows contain the value of one SPBal at all time points. The selected principal balance of the row i+1 has at its numerator the bacteria placed in the rows \code{NumSPBal[[i]]} of the "especie". The selected principal balance of the row i+1 has at its denominator the bacteria placed in the rows \code{DemSPBal[[i]]} of the "especie".}
}
\value{
Returns a list with:

\itemize{
   \item ExpectedValue.All:  Matrix. Matrix that contains at row i the expected value of the bacteria i at all time points t=1,2,...,K. The bacterias are placed at the same order than in \code{especies}.
   \item VarianceValue.All:  Matrix. Matrix that contains at row i the variance of the bacteria i at all time points t=1,2,...,K. The bacterias are placed at the same order than in \code{especies}.
   \item DirichlerParam.All: Matrix.   Matrix that contains at row i the dirichlet parameter of the bacteria i at all time points t=1,2,...,K. The bacterias are placed at the same order than in \code{especies}.
   \item ExpVarmas:  Matrix. Matrix that contains at row i the expected value plus two times the sqrt(variance) of the bacteria i at all time points t=\code{Tt},...,K, the rest of the time points has 0 values. The bacterias are placed at the same order than in \code{especies}.
   \item ExpVarmenos:  Matrix. Matrix that contains at row i the expected value plus two times the sqrt(variance) of the bacteria i at all time points t=\code{Tt},...,K,the rest of the time points has 0 values. The bacterias are placed at the same order than in \code{especies}.

  }
}
\description{
This function calculates the expected value and variance of the bacteria at time point \code{Tt}. Then, this function calculates the expected value and variance of the bacteria at time point t=(\code{Tt}+1),...,K. It calculates the expected value at each time point for each markov chain iteration. The expected value for each time point is the mean of the expected values of all iterations.mAnalogous with the variance, the dirichlet parameters and the expected valur plus(and minus) two times the sqrt of the variance.
}
\examples{

NumSPBal=list(1,c(1,2))
DemSPBal=list(2,3)
MCMC.CHAINS=cbind(c(0.1,0.11),
                 c(0.2,0.21),
                 c(0.3,0.31),
                 c(-0.1,-0.11),
                 c(0.15,0.105),
                 c(0.44,0.41),
                 c(0.3,0.31),
                 c(0.201,0.221),
                 c(0.13,0.113) )
alpha=cbind(c(0.1,0.2,0.1),c(0.1,0.5,0.3))
K=3
esperanza=cbind(c(0.2,0.2,0.6))
Var=cbind(c(0.1,0.01,0.11))
E=3
Tt=2
MatrizPBmodelo=cbind(c(1,0.3,0.2))

PredictionBPBM(NumSPBal,DemSPBal,MCMC.CHAINS, alpha,K,esperanza,Var,E,Tt,MatrizPBmodelo )

}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2022). Bayesian hierarchical compositional models for analysing longitudinal abundance data from microbiome studies. Complexity, 2022.
}
