% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inertdiss.R
\name{inertdiss}
\alias{inertdiss}
\title{Pseudo inertia of a cluster}
\usage{
inertdiss(D, indices = NULL, wt = NULL)
}
\arguments{
\item{D}{an object of class "dist" with the dissimilarities between the n observations. 
The function \code{\link{as.dist}} can be used to transform an object of class matrix to object of class "dist".}

\item{indices}{a vector with the indices of the subset of observations.}

\item{wt}{vector with the weights of the n observations}
}
\description{
The pseudo inertia of a cluster is calculated from a dissimilarity matrix
and not from a data matrix.
}
\examples{
data(estuary)
n <- nrow(estuary$dat)
Z <- scale(estuary$dat)*sqrt(n/(n-1))
inertdiss(dist(Z)) # pseudo inertia
inert(Z) #equals for euclidean distance

w <- estuary$map@data$POPULATION # non uniform weights 
inertdiss(dist(Z),wt=w)
}
\references{
M.chavent, V. Kuentz-Simonet, A. Labenne, J. Saracco.  ClustGeo:  an R package 
for hierarchical clustering with spatial constraints	arXiv:1707.03897 [stat.CO]
}

