% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/heterog.Ck.R
\name{heterog.Ck}
\alias{heterog.Ck}
\title{heterogeneity of a class C_k obtained with the method \code{hclust.geo.H}.}
\usage{
heterog.Ck(dist.var, dist.geo, partition, classe, wt, alpha)
}
\arguments{
\item{dist.var}{a square symetric matrix with the distances between individuals measured on the variables.}

\item{dist.geo}{a square symetric matrix with the geographical distances between individuals.}

\item{partition}{a vector of size \code{n} giving the belonging of each individuals to each class of individuals.}

\item{classe}{the number of the class for which we want the heterogeneity.}

\item{wt}{a vector of size \code{n} whose values indicate weights of individuals on quantitative variables}

\item{alpha}{a real between 0 and 1 to fit the global criterion to optimize}
}
\value{
{res} {a list containing the following results : the Inertia of the class based on \code{dist.var},
 the Inertia of the class based on \code{dist.geo}, the heterogeneity of the class as defined in description.}
}
\description{
This function calculate the heterogeneity of a class C_k obtained with the method \code{hclust.geo.H}.
heterogeneity= alpha I_intra_var + (1-alpha) I_intra_geo.
}
\details{
Note that in the calcul of Inertia, the two matrices of distances are normalized (divided by their own maximum).
}
\keyword{internal}

