% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECS.R
\name{element_sim_elscore}
\alias{element_sim_elscore}
\title{The Element-Centric Clustering Similarity for each Element}
\usage{
element_sim_elscore(clustering1, clustering2)
}
\arguments{
\item{clustering1}{The first Clustering.}

\item{clustering2}{The second Clustering.}
}
\value{
Vector of element-centric similarity between the two clusterings for
 each element.
}
\description{
Calculates the element-wise element-centric similarity between
two Clustering objects.
}
\examples{
km.res = kmeans(iris[,1:4], centers=8)$cluster
km.clustering = create_clustering(km.res)
hc.res = hclust(dist(iris[,1:4]))
hc.clustering = create_clustering(hc.res)
element_sim_elscore(km.clustering, hc.clustering)
}
\references{
Gates, A. J., Wood, I. B., Hetrick, W. P., & Ahn, Y. Y. (2019).
Element-centric clustering comparison unifies overlaps and hierarchy.
Scientific reports, 9(1), 1-13. https://doi.org/10.1038/s41598-019-44892-y
}
