% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomise.R
\name{randomise}
\alias{randomise}
\alias{randomize}
\title{Randomised group of items}
\usage{
randomise(
  npackages,
  itemnames,
  ncomp = 3,
  availability = NULL,
  proportions = NULL,
  ...
)
}
\arguments{
\item{npackages}{an integer for the number of trial packages to be produced}

\item{itemnames}{a character for the name of items tested in the project}

\item{ncomp}{an integer for the number of items to be assigned to each package}

\item{availability}{optional, a vector with integers indicating the 
number of packages available for each \var{itemnames}}

\item{proportions}{optional, a numeric vector with the desired proportions
for each \var{itemnames}}

\item{...}{additional arguments passed to methods}
}
\value{
A dataframe with the randomised design
}
\description{
Set a randomised group of items for crowdsourcing citizen science.
Generate designs for ranking of options. It is designed for tricot trials 
specifically (comparing 3 options), but it will also work with comparisons 
of any other number of options. 
The design strives for approximate A optimality, this means that it is robust 
to missing observations. It also strives for balance for positions of each option.
Options are equally divided between first, second, third, etc. position. 
The strategy is to create a "pool" of combinations that does not repeat 
combinations and is A-optimal. Then this pool is ordered to make subsets of 
consecutive combinations also relatively balanced and A-optimal
}
\examples{
ncomp <- 3
npackages <- 100
itemnames <- c("apple","banana","grape","mango", "orange", "kiwi", "pineapple")
availability <- c(50, 50, 150, 150, 150, 150, 20)

table(unlist(randomise(ncomp = ncomp,
                       npackages = npackages,
                       itemnames = itemnames)))

table(unlist(randomise(ncomp = ncomp,
                       npackages = npackages,
                       itemnames = itemnames,
                       availability = availability)))
          
}
\author{
Jacob van Etten
}
