% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProjectsCM.R
\name{getProjectsCM}
\alias{getProjectsCM}
\title{Get ClimMob projects}
\usage{
getProjectsCM(key = NULL)
}
\arguments{
\item{key}{a character for the user's application programming 
interface (API) key}
}
\value{
A data frame with the ClimMob projects 
\item{project_id}{the project unique id}
\item{name}{the project name}
\item{status}{the current status}
\item{creation_date}{the project's creation date}
\item{intended_participants}{the number of participants the project 
 intended to register}
\item{registration_progress}{the percentage of intended participants 
 which were registered}
\item{last_registration_activity}{number of days since the submission 
 of the last registration}
}
\description{
Get ClimMob projects using an application programming interface (API) key
}
\examples{
\dontrun{ 
# This function will not work without an API key  
# the user API key can be obtained once a free ClimMob account 
# is created via https://climmob.net/climmob3/

my_key <- "add_your_key"

getProjectsCM(key = my_key)

}

}
\seealso{
\url{https://climmob.net/climmob3/}
}
\author{
Kauê de Sousa
}
