% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_segment_definitions.R
\name{read_segment_definitions}
\alias{read_segment_definitions}
\title{Read Segment Definitions from Excel File}
\usage{
read_segment_definitions(filepath)
}
\arguments{
\item{filepath}{A string specifying the path to the Excel file containing segment definitions.}
}
\value{
A named list where each element is a character vector of marker names defining a segment.
}
\description{
Reads an Excel file defining the markers in each segment and creates a list suitable for use with
\code{plot_chest_3d} and \code{calculate_segment_volumes} functions.
}
\details{
The Excel file should have a specific format:
\itemize{
\item Each row represents a segment.
\item The first column contains the segment names.
\item Subsequent columns contain the marker names belonging to each segment.
}
Missing marker entries can be left blank or filled with \code{NA}.
}
\examples{
# 'segment_def.xlsx' is the Excel file with segment definitions
path <- system.file("extdata", "segment_def.xlsx", package="ChestVolume")
segments <- read_segment_definitions(path)
head(segments)
}
