% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normSpectra2D.R
\name{normSpectra2D}
\alias{normSpectra2D}
\title{Normalize a Spectra2D Object}
\usage{
normSpectra2D(spectra, method = "zero2one")
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra2D}} to be normalized.}

\item{method}{One of \code{"TotInt"} or \code{"zero2one"} giving
the method for normalization.  Other methods may be added in the future.}
}
\value{
An object of S3 class \code{\link{Spectra2D}}.
}
\description{
This function carries out normalization of the spectra in a
\code{\link{Spectra2D}} object.  There are currently two options:
\itemize{
  \item \code{"zero2one"} normalizes each 2D spectrum to a [0 \ldots{} 1] scale.
  \item \code{"TotInt"} normalizes each 2D spectrum so that the total area is one.
}
}
\examples{

data(MUD1)
MUD1n <- normSpectra2D(MUD1)
MUD1b <- removeFreq(MUD1, remF2 = 2.5 ~ 3.5)
MUD1bn <- normSpectra2D(MUD1b)

}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{utilities}
