% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalClusters.R
\name{evalClusters}
\alias{evalClusters}
\title{Evaluate or Compare the Quality of Clusters Quantitatively}
\usage{
evalClusters(spectra, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[=Spectra]{Spectra()}}.}

\item{\dots}{Other parameters to be passed to the function. In particular,
\code{NbClust} package will need some parameters.  See the
example.}
}
\value{
A list giving the results, as described in \code{\link[NbClust]{NbClust}}.
}
\description{
This function is a wrapper for \code{NbClust} in package \pkg{NbClust}. It
can be used to quantitatively compare different clustering options.
}
\examples{

\dontrun{
data(metMUD2)
res <- evalClusters(metMUD2, min.nc = 2, max.nc = 5, method = "average", index = "kl")
}

}
\references{
M. Charrad et. al.  "NbClust: An R Package for Determining the
Relevant Number of Clusters in a Data Set."  J. Stat. Soft. vol. 61 no. 6
October 2014.
}
\seealso{
\code{\link{hclust}} for the underlying base function.
\code{\link{hcaSpectra}} for HCA analysis of a \code{\link{Spectra}} object.
\code{\link{hcaScores}} for HCA analysis of PCA scores from a
\code{\link{Spectra}} object. Additional documentation at
\url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University).
}
\keyword{cluster}
\keyword{multivariate}
