% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra.R
\name{Spectra}
\alias{Spectra}
\title{Spectra Objects}
\description{
In \code{ChemoSpec}, spectral data sets are stored in an S3 class called
\code{Spectra}, which contains a variety of information in addition to the
spectra themselves.  \code{Spectra} objects are created by
\code{\link{files2SpectraObject}} or \code{\link{matrix2SpectraObject}}.
}
\section{Structure}{
 The structure of a \code{Spectra} object is a list of 9
elements and an attribute as follows:
\itemize{
\item \strong{$freq} (numeric) A common frequency (or wavelength) axis for all the spectra.
\item \strong{$data} (numeric) The intensities for the spectra.  A matrix of dimension no. samples x no. frequency points.
\item \strong{$names} (character) The sample names for the spectra; length must be no. samples.
\item \strong{$groups} (factor) The group classification of the samples; length must be no. samples.
\item \strong{$colors} (character) The colors for each sample; length must be no. samples. Groups and colors correspond.
\item \strong{$sym} (integer) As for \code{colors}, but symbols for plotting (if b/w is desired).
\item \strong{$alt.sym} (character) Lower-case letters as alternate symbols for plotting.
\item \strong{$unit} (character) Two entries, the first giving the x axis unit, the second the y axis unit.
\item \strong{$desc} (character) A character string describing the data set.  This appears on plots and therefore should probably be kept to 40 characters or less.
\item attribute: character with value "Spectra" The S3 class designation.
}
}

\seealso{
\code{\link{sumSpectra}} to summarize a \code{Spectra} object.
\code{\link{sumGroups}} to summarize group membership of a \code{Spectra}
object. \code{\link{chkSpectra}} to verify the integrity of a
\code{Spectra} object. \code{\link{colorSymbol}} for a discussion of color
options. Finally, additional documentation at \url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University).
}
\keyword{classes}
