% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitmodel.R
\name{fitmodel}
\alias{fitmodel}
\title{Executes an NLME simple estimation}
\usage{
fitmodel(
  model,
  hostPlatform = NULL,
  params,
  simpleTables,
  runInBackground = FALSE,
  filesToReturn = "*",
  ...
)
}
\arguments{
\item{model}{PK/PD model class object.}

\item{hostPlatform}{Host definition for model execution. See \code{\link{hostParams}}.
If \code{missing}, PhoenixMPIDir64 is given  and MPI is installed,
MPI local host with 4 threads is used. If MPI is not found, local host
without parallelization is used.}

\item{params}{Engine parameters. See \code{\link{engineParams}}.
If \code{missing}, default parameters generated by engineParams(model) are used.}

\item{simpleTables}{Optional list of simple tables. See
\code{\link{tableParams}}. By default a table named 'posthoc.csv' is returned
with structural parameters values for all source data rows.}

\item{runInBackground}{Set to \code{TRUE} to run in background and return prompt.}

\item{filesToReturn}{Used to specify which files to be outputted to the model directory
and loaded as returned value. By default, all the applicable files listed
in the \code{Value} section will be outputted to the model directory and loaded as returned value.
Only those files listed in the \code{Value} section can be specified.
Simple regex patterns are supported for the specification.}

\item{...}{Additional arguments for  \code{\link{hostParams}}
or arguments available inside \code{\link{engineParams}} functions.
If \code{\link{engineParams}} arguments are supplied through both \code{params} argument
and additional argument (i.e., ellipsis), then the arguments in \code{params} will be ignored
and only the additional arguments will be used with warning.
If \code{\link{hostParams}} arguments are supplied through both the \code{hostPlatform}
argument and the ellipses, values supplied to \code{hostPlatform} will be overridden by
additional arguments supplied via the ellipses e.g., \code{...}.}
}
\value{
if \code{runInBackground} is \code{FALSE}, a list with  main
resulted dataframes is returned:
\itemize{
\item Overall
\item ConvergenceData
\item residuals
\item Secondary
\item StrCovariate  - if continuous covariates presented
\item StrCovariateCat - if categorical covariates presented
\item theta
\item posthoc table
\item posthocStacked table
\item Requested tables
}

\code{nlme7engine.log} textual output is returned and loaded with the main information related to
fitting. \code{dmp.txt} structure with the results of fitting (including LL by subject information)
is returned and loaded. These 2 files are returned and loaded irrespective of
\code{filesToReturn} argument value.

For individual models, additional dataframe with partial derivatives is returned:
\itemize{
\item ParDer
}

For population models and the method specified is NOT \code{Naive-Pooled},
additional dataframes are returned:
\itemize{
\item omega
\item Eta
\item EtaStacked
\item EtaEta
\item EtaCov
\item EtaCovariate - if continuous covariates presented
\item EtaCovariateCat - if categorical covariates presented
\item bluptable.dat
}

If standard error computation was requested and it was successful, additional dataframes
are returned:
\itemize{
\item thetaCorrelation
\item thetaCovariance
\item Covariance
\item omega_stderr
}

If nonparametric method was requested (\code{numIterNonParametric} > 0) and
the \code{method} specified in \code{engineParams}  is NOT \code{Naive-Pooled},
additional dataframes are returned:
\itemize{
\item nonParSupportResult
\item nonParStackedResult
\item nonParEtaResult
\item nonParOverallResult
}

if \code{runInBackground} is \code{TRUE}, only current status of job is returned.
}
\description{
Executes an NLME simple estimation
}
\section{\code{filesToReturn} with \code{Certara.Xpose.NLME}}{

If \code{filesToReturn} is used and "ConvergenceData.csv" and "residuals.csv"
are not in the patterns, these files won't be returned and loaded. These files
are essential for \code{Certara.Xpose.NLME::xposeNlmeModel} and
\code{Certara.Xpose.NLME::xposeNlme} functions. This makes impossible to
use the resulted object in \code{Certara.Xpose.NLME} functions.
}

\section{Non-loaded but returned files}{

The non-loaded but returned files in the model working directory are:
\itemize{
\item err1.txt - concatenated for all runs detailed logs for all steps of optimization,
\item out.txt - general pivoted information about results,
\item doses.csv - information about doses given for all subjects,
\item iniest.csv - information about initial estimates
}
}

\examples{
\donttest{

 # Define the host
 host <- hostParams(parallelMethod = "None",
                    hostName = "local",
                    numCores = 1)
 # Define the model
 model <- pkmodel(numComp = 2,
                  absorption = "FirstOrder",
                  ID = "Subject",
                  Time = "Act_Time",
                  CObs = "Conc",
                  Aa = "Amount",
                  data = pkData,
                  modelName = "PkModel")

 Table01 <- tableParams(name = "SimTableObs.csv",
                        timesList = "0,1,2,4,4.9,55.1,56,57,59,60",
                        variablesList = "C, CObs",
                        timeAfterDose = FALSE,
                        forSimulation = FALSE)

 # Update fixed effects
 model <- fixedEffect(model,
                     effect = c("tvV", "tvCl", "tvV2", "tvCl2"),
                     value = c(16, 41, 7, 14))

 # Define the engine parameters
 params <- engineParams(model)

 # Fit model
 res <- fitmodel(model = model,
                 hostPlatform = host,
                 params = params,
                 simpleTables = Table01)
}

}
\seealso{
\code{\link{tableParams}, \link{hostParams},
\link{engineParams}}
}
