% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pml_model.r
\name{addSecondary}
\alias{addSecondary}
\alias{addSecondary,NlmePmlModel-method}
\title{Adds a secondary parameter to model definition}
\usage{
addSecondary(.Object, name, definition, unit = "")

\S4method{addSecondary}{NlmePmlModel}(.Object, name, definition, unit = "")
}
\arguments{
\item{.Object}{An 'NlmePmlModel' object to which you want to add a secondary parameter.}

\item{name}{Name of the secondary parameter.}

\item{definition}{Definition of secondary parameter.}

\item{unit}{Optional units of the secondary parameter. The default is "".}
}
\value{
Depends on the specific methods

Returns the 'NlmePmlModel' object with the added secondary parameter.
}
\description{
Adds a secondary parameter to model definition
}
\section{Functions}{
\itemize{
\item \code{addSecondary(NlmePmlModel)}: Method for the 'NlmePmlModel' class

This method adds a secondary parameter to the NlmePmlModel object.
It checks for duplicate parameter names, and if there is no duplicate,
it adds the new secondary parameter to the object and updates the PML model.

}}
\examples{
\donttest{
model <- addSecondary(model, "Spc_Param", "log(2)/tvKe")
model <- addSecondary(
  model, "Tmax",
  "CalcTMax(tvA,tvAlpha,tvB,tvBeta,C,Gamma)"
)
}

}
