% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_stan_data.R
\name{prep_stan_data}
\alias{prep_stan_data}
\title{Prepare data for 'stan'}
\usage{
prep_stan_data(model, data, keep_transformed = TRUE)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by \code{\link{make_model}}.}

\item{data}{A \code{data.frame}.  Data of nodes that can take three values: 0, 1, and NA. In long form as generated by \code{\link{make_events}}}
}
\value{
A \code{list} containing data to be passed to 'stan'
}
\description{
Create a list containing the data to be passed to 'stan
}
\examples{
\donttest{
model <- make_model('X->Y')
data  <-  collapse_data(simulate_data(model, n = 6), model)
CausalQueries:::prep_stan_data(model, data)

model <- make_model('X->Y') \%>\% set_confound(list(X = 'Y[X=1]>Y[X=0]'))
data  <-  collapse_data(simulate_data(model, n = 6), model)
CausalQueries:::prep_stan_data(model, data)
}

}
\keyword{internal}
