% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\docType{data}
\name{model.class}
\alias{model.class}
\title{A Reference Class to generates differents model objects}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
model.class
}
\description{
See the function \code{\link{model}} which produces an instance of this class
This class comes with a set of methods, some of them being useful for the user:
See the documentation for \code{\link{model}}... Other methods
should not be called as they are designed to be used during the calibration process.


Fields should not be changed or manipulated by the user as they are updated internally
during the estimation process.
}
\section{Fields}{

\describe{
\item{\code{code}}{a function which takes in entry X and theta}

\item{\code{X}}{the matrix of the forced variables}

\item{\code{Yexp}}{the experimental output}

\item{\code{n}}{the number of experiments}

\item{\code{d}}{the number of forced variables}

\item{\code{binf}}{the lower bound of the parameters for the DOE}

\item{\code{bsup}}{the upper bound of the parameters for the DOE}

\item{\code{opt.gp}}{a list of parameter for the surrogate (default NULL) \itemize{
\item{\strong{type}}{ type of the chosen kernel (value by default "matern5_2") from \code{\link{km}} function}
\item{\strong{DOE}}{ design of experiments for the surrogate (default value NULL)}}}

\item{\code{opt.emul}}{a list of parameter to establish the DOE (default NULL) \itemize{
\item{\strong{p}}{ the number of parameter in the model (default value 1)}
\item{\strong{n.emul}}{ the number of points for constituting the Design Of Experiments (DOE) (default value 100)}
\item{\strong{binf}}{ the lower bound of the parameter vector (default value 0)}
\item{\strong{bsup}}{ the upper bound of the parameter vector (default value 1)}}}

\item{\code{opt.sim}}{a list of parameter containing output of the code and corresponding DOE \itemize{
\item{\strong{Ysim}}{ Output of the code}
\item{\strong{DOEsim}}{ DOE corresponding to the output of the code}}}

\item{\code{model}}{the model choice (see \code{\link{model}} for more specification).}

\item{\code{opt.disc}}{a list of parameter for the discrepancy \itemize{
\item{\strong{kernel.type}}{ the kernel chosen for the Gaussian process}}}
}}

\keyword{datasets}
