% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{calibrate}
\alias{calibrate}
\title{Generates \code{\link{calibrate.class}} objects}
\usage{
calibrate(md, pr, opt.estim, opt.valid = NULL, onlyCV = FALSE)
}
\arguments{
\item{md}{a \code{\link{model.class}} object}

\item{pr}{a \code{\link{prior.class}} object}

\item{opt.estim}{estimation options \itemize{\item{Ngibbs}{Number of iteration of the algorithm Metropolis within Gibbs}
\item{Nmh}{ Number of iteration of the Metropolis Hastings algorithm}
\item{thetaInit}{ Initial point}
\item{k}{ Tuning parameter for the covariance matrix sig}
\item{sig}{ Covariance matrix for the proposition distribution (\eqn{k*sig})}
\item{Nchains}{ Number of MCMC chains to run (if Nchain>1 an output is created called mcmc which is a coda object)}
\item{burnIn}{ Number of iteration to withdraw}
}}

\item{opt.valid}{list of cross validation options (default opt.valid=FALSE)\itemize{
\item{nCV}{ Number of iterations for the cross validation}
\item{type.valid}{ Type of cross validation selected. "loo" (leave one out) is the only method emplemented so far.}
}}

\item{onlyCV}{if TRUE run the cross validation only (default onlyCV=FALSE)}
}
\value{
\code{calibrate} returns a \code{\link{calibrate.class}} object. Two main methods are available:
\itemize{\item{plot()}{ display the probability density of the prior with different options:}
\itemize{
\item {mdfit}{The calibrated model (a \code{\link{calibrate.class}} object)}
\item {graph}{ The vector of the graph wanted. By default all the graph are displayed and graph=c("acf","chains","densities","output").
"acf" displays the correlation graph of the MCMC chains, "chains" plot the chains, "densities" shows the comparison of the
densities a priori and a posteriori, and "output" displays the output of the code with the calibrated one and its credibility
interval.}
\item {select.X}{ When the number of X is >1, this option has to be activated to display the output plot. select.X
allows to choose one X for the x scale in the output plot}}
\item{print()}{ return the main information concerning the estim.class object}}
}
\description{
\code{calibration} is a function that allows us to generate a \code{\link{calibrate.class}} class in which the estimation is
done from a \code{\link{model.class}} and a \code{\link{prior.class}} objects.
}
\examples{
\dontrun{
###################### The code to calibrate
X <- cbind(seq(0,1,length.out=10),seq(0,1,length.out=10))
code <- function(X,theta)
{
  return((6*X[,1]*theta[2]-2)^2*theta[1]*sin(theta[3]*X[,2]-4))
}
Yexp <- code(X,c(1,1,11))+rnorm(10,0,0.1)

############### For the first model
###### Definition of the model
md <- model(code,X,Yexp,"model1")
###### Definition of the prior densities
pr <- prior(type.prior=c("gaussian","gaussian","gaussian","gamma"),opt.prior=
list(c(1,0.01),c(1,0.01),c(11,3),c(2,0.1)))
###### Definition of the calibration options
opt.estim=list(Ngibbs=200,Nmh=400,thetaInit=c(1,1,11,0.1),k=c(6e-3,1e-3,1e-5,1e-3),
sig=diag(4),Nchains=1,burnIn=100)
###### Run the calibration
mdfit <- calibrate(md,pr,opt.estim)
####### The plot generated is a list of ggplot
p <- plot(mdfit,select.X=X[,1])
p$output
print(mdfit)
}
}
\seealso{
\code{\link{prior}},\code{\link{calibrate}},\code{\link{prediction}}, \code{\link{kernel.fun}}
}
\author{
M. Carmassi
}
