% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementwise.R
\docType{class}
\name{Huber-class}
\alias{Huber-class}
\alias{.Huber}
\alias{Huber}
\alias{to_numeric,Huber-method}
\alias{sign_from_args,Huber-method}
\alias{is_atom_convex,Huber-method}
\alias{is_atom_concave,Huber-method}
\alias{is_incr,Huber-method}
\alias{is_decr,Huber-method}
\alias{is_quadratic,Huber-method}
\alias{get_data,Huber-method}
\alias{validate_args,Huber-method}
\alias{.grad,Huber-method}
\title{The Huber class.}
\usage{
Huber(x, M = 1)

\S4method{to_numeric}{Huber}(object, values)

\S4method{sign_from_args}{Huber}(object)

\S4method{is_atom_convex}{Huber}(object)

\S4method{is_atom_concave}{Huber}(object)

\S4method{is_incr}{Huber}(object, idx)

\S4method{is_decr}{Huber}(object, idx)

\S4method{is_quadratic}{Huber}(object)

\S4method{get_data}{Huber}(object)

\S4method{validate_args}{Huber}(object)

\S4method{.grad}{Huber}(object, values)
}
\arguments{
\item{x}{An \linkS4class{Expression} object.}

\item{M}{A positive scalar value representing the threshold. Defaults to 1.}

\item{object}{A \linkS4class{Huber} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}
}
\description{
This class represents the elementwise Huber function, \eqn{Huber(x, M) = }
\itemize{
  \item{\eqn{2M|x|-M^2}}{for \eqn{|x| \geq |M|}}
   \item{\eqn{|x|^2}}{for \eqn{|x| \leq |M|.}}
 }
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric(Huber)}: The Huber function evaluted elementwise on the input value.

\item \code{sign_from_args(Huber)}: The atom is positive.

\item \code{is_atom_convex(Huber)}: The atom is convex.

\item \code{is_atom_concave(Huber)}: The atom is not concave.

\item \code{is_incr(Huber)}: A logical value indicating whether the atom is weakly increasing.

\item \code{is_decr(Huber)}: A logical value indicating whether the atom is weakly decreasing.

\item \code{is_quadratic(Huber)}: The atom is quadratic if \code{x} is affine.

\item \code{get_data(Huber)}: A list containing the parameter \code{M}.

\item \code{validate_args(Huber)}: Check that \code{M} is a non-negative constant.

\item \code{.grad(Huber)}: Gives the (sub/super)gradient of the atom w.r.t. each variable

}}
\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} or numeric constant.}

\item{\code{M}}{A positive scalar value representing the threshold. Defaults to 1.}
}}

