% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{bmat}
\alias{bmat}
\title{Block Matrix}
\usage{
bmat(block_lists)
}
\arguments{
\item{block_lists}{A list of lists containing \linkS4class{Expression} objects, matrices, or vectors, which represent the blocks of the block matrix.}
}
\value{
An \linkS4class{Expression} representing the block matrix.
}
\description{
Constructs a block matrix from a list of lists. Each internal list is stacked horizontally, and the internal lists are stacked vertically.
}
\examples{
x <- Variable()
expr <- bmat(list(list(matrix(1, nrow = 3, ncol = 1), matrix(2, nrow = 3, ncol = 2)),
                list(matrix(3, nrow = 1, ncol = 2), x)
             ))
prob <- Problem(Minimize(sum_entries(expr)), list(x >= 0))
result <- solve(prob)
result$value
}
