% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementwise.R
\docType{class}
\name{Square-class}
\alias{Square-class}
\alias{.Square}
\alias{Square}
\alias{Square}
\alias{validate_args,Square-method}
\alias{to_numeric,Square-method}
\alias{get_data,Square-method}
\alias{sign_from_args,Square-method}
\alias{is_atom_convex,Square-method}
\alias{is_atom_concave,Square-method}
\alias{is_incr,Square-method}
\alias{is_decr,Square-method}
\alias{is_quadratic,Square-method}
\alias{graph_implementation,Square-method}
\title{The Square class.}
\usage{
Square(x)

\S4method{validate_args}{Square}(object)

\S4method{to_numeric}{Square}(object, values)

\S4method{get_data}{Square}(object)

\S4method{sign_from_args}{Square}(object)

\S4method{is_atom_convex}{Square}(object)

\S4method{is_atom_concave}{Square}(object)

\S4method{is_incr}{Square}(object, idx)

\S4method{is_decr}{Square}(object, idx)

\S4method{is_quadratic}{Square}(object)

\S4method{graph_implementation}{Square}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{x}{An \linkS4class{Expression} object.}

\item{object}{A \linkS4class{Square} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the elementwise square \eqn{x^2}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{validate_args}: Verification of arguments happens during initialization.

\item \code{to_numeric}: The elementwise square of the input value.

\item \code{get_data}: A list containing the output of \code{pow_high}.

\item \code{sign_from_args}: The atom is positive.

\item \code{is_atom_convex}: The atom is convex.

\item \code{is_atom_concave}: The atom is not concave.

\item \code{is_incr}: A logical value indicating whether the atom is weakly increasing.

\item \code{is_decr}: A logical value indicating whether the atom is weakly decreasing.

\item \code{is_quadratic}: Is \code{x} affine?

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} object.}
}}

