% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{LogSumExp-class}
\alias{LogSumExp-class}
\alias{.LogSumExp}
\alias{LogSumExp}
\alias{to_numeric,LogSumExp-method}
\alias{sign_from_args,LogSumExp-method}
\alias{is_atom_convex,LogSumExp-method}
\alias{is_atom_concave,LogSumExp-method}
\alias{is_incr,LogSumExp-method}
\alias{is_decr,LogSumExp-method}
\alias{graph_implementation,LogSumExp-method}
\title{The LogSumExp class.}
\usage{
LogSumExp(x, axis = NA_real_)

\S4method{to_numeric}{LogSumExp}(object, values)

\S4method{sign_from_args}{LogSumExp}(object)

\S4method{is_atom_convex}{LogSumExp}(object)

\S4method{is_atom_concave}{LogSumExp}(object)

\S4method{is_incr}{LogSumExp}(object, idx)

\S4method{is_decr}{LogSumExp}(object, idx)

\S4method{graph_implementation}{LogSumExp}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{x}{An \linkS4class{Expression} representing a vector or matrix.}

\item{axis}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}

\item{object}{A \linkS4class{LogSumExp} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
The natural logarithm of the sum of the elementwise exponential, \eqn{\log\sum_{i=1}^n e^{x_i}}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: Evaluates \eqn{e^x} elementwise, sums, and takes the natural log.

\item \code{sign_from_args}: The atom is positive.

\item \code{is_atom_convex}: The atom is convex.

\item \code{is_atom_concave}: The atom is not concave.

\item \code{is_incr}: The atom is monotonically non-decreasing.

\item \code{is_decr}: The atom is not monotonically non-increasing.

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} representing a vector or matrix.}

\item{\code{axis}}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}
}}

