% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementwise.R
\docType{class}
\name{Log-class}
\alias{Log-class}
\alias{.Log}
\alias{Log}
\alias{to_numeric,Log-method}
\alias{sign_from_args,Log-method}
\alias{is_atom_convex,Log-method}
\alias{is_atom_concave,Log-method}
\alias{is_incr,Log-method}
\alias{is_decr,Log-method}
\alias{graph_implementation,Log-method}
\title{The Log class.}
\usage{
Log(x)

\S4method{to_numeric}{Log}(object, values)

\S4method{sign_from_args}{Log}(object)

\S4method{is_atom_convex}{Log}(object)

\S4method{is_atom_concave}{Log}(object)

\S4method{is_incr}{Log}(object, idx)

\S4method{is_decr}{Log}(object, idx)

\S4method{graph_implementation}{Log}(object, arg_objs, size,
  data = NA_real_)
}
\arguments{
\item{x}{An \linkS4class{Expression} or numeric constant.}

\item{object}{A \linkS4class{Log} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the elementwise natural logarithm \eqn{\log(x)}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: The elementwise natural logarithm of the input value.

\item \code{sign_from_args}: The sign of the atom is unknown.

\item \code{is_atom_convex}: The atom is not convex.

\item \code{is_atom_concave}: The atom is concave.

\item \code{is_incr}: The atom is weakly increasing.

\item \code{is_decr}: The atom is not weakly decreasing.

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} or numeric constant.}
}}

