% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problem.R
\docType{class}
\name{Maximize-class}
\alias{Maximize-class}
\alias{.Maximize}
\alias{Maximize}
\alias{canonicalize,Maximize-method}
\alias{is_dcp,Maximize-method}
\alias{is_quadratic,Maximize-method}
\title{The Maximize class.}
\usage{
Maximize(expr)

\S4method{canonicalize}{Maximize}(object)

\S4method{is_dcp}{Maximize}(object)

\S4method{is_quadratic}{Maximize}(object)
}
\arguments{
\item{expr}{A scalar \linkS4class{Expression} to maximize.}

\item{object}{A \linkS4class{Maximize} object.}
}
\description{
This class represents an optimization objective for maximization.
}
\section{Methods (by generic)}{
\itemize{
\item \code{canonicalize}: Negates the target expression's objective.

\item \code{is_dcp}: A logical value indicating whether the objective is concave.

\item \code{is_quadratic}: A logical value indicating whether the objective is quadratic.
}}

\section{Slots}{

\describe{
\item{\code{expr}}{A scalar \linkS4class{Expression} to maximize.}
}}

\examples{
x <- Variable(3)
alpha <- c(0.8,1.0,1.2)
obj <- sum(log(alpha + x))
constr <- list(x >= 0, sum(x) == 1)
prob <- Problem(Maximize(obj), constr)
result <- solve(prob)
result$value
result$getValue(x)
}
