% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementwise.R
\docType{class}
\name{Entr-class}
\alias{Entr-class}
\alias{.Entr}
\alias{Entr}
\alias{Entr}
\alias{to_numeric,Entr-method}
\alias{sign_from_args,Entr-method}
\alias{is_atom_convex,Entr-method}
\alias{is_atom_concave,Entr-method}
\alias{is_incr,Entr-method}
\alias{is_decr,Entr-method}
\alias{graph_implementation,Entr-method}
\title{The Entr class.}
\usage{
Entr(x)

\S4method{to_numeric}{Entr}(object, values)

\S4method{sign_from_args}{Entr}(object)

\S4method{is_atom_convex}{Entr}(object)

\S4method{is_atom_concave}{Entr}(object)

\S4method{is_incr}{Entr}(object, idx)

\S4method{is_decr}{Entr}(object, idx)

\S4method{graph_implementation}{Entr}(object, arg_objs, size, data = NA_real_)
}
\arguments{
\item{x}{An \linkS4class{Expression} or numeric constant.}

\item{object}{An \linkS4class{Entr} object.}

\item{values}{A list of arguments to the atom.}

\item{idx}{An index into the atom.}

\item{arg_objs}{A list of linear expressions for each argument.}

\item{size}{A vector with two elements representing the size of the resulting expression.}

\item{data}{A list of additional data required by the atom.}
}
\description{
This class represents the elementwise operation \eqn{-xlog(x)}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric}: The elementwise entropy function evaluated at the value.

\item \code{sign_from_args}: The sign of the atom is unknown.

\item \code{is_atom_convex}: The atom is not convex.

\item \code{is_atom_concave}: The atom is concave.

\item \code{is_incr}: The atom is weakly increasing.

\item \code{is_decr}: The atom is weakly decreasing.

\item \code{graph_implementation}: The graph implementation of the atom.
}}

\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} or numeric constant.}
}}

