% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotWeeklyClim.R
\name{PlotWeeklyClim}
\alias{PlotWeeklyClim}
\title{Plots the observed weekly means and climatology of a timeseries data}
\usage{
PlotWeeklyClim(
  data,
  first_date,
  ref_period_ini,
  ref_period_end,
  time_dim = "time",
  sdate_dim = "sdate",
  title = "Observed weekly means and climatology",
  palette = "Blues",
  fileout = NULL,
  device = NULL,
  width = 8,
  height = 6,
  units = "in",
  dpi = 300
)
}
\arguments{
\item{data}{A multidimensional array with named dimensions with at least sdate 
and time dimensions containing observed daily data. It can also be a 
dataframe with computed percentiles as input for ggplot. The target year 
must be included in the input data.}

\item{first_date}{The first date of the target period of timeseries. It can be 
of class 'Date', 'POSIXct' or a character string in the format 'yyyy-mm-dd'. 
It must be a date included in the reference period.}

\item{ref_period_ini}{A numeric value indicating the first year of the 
reference period.}

\item{ref_period_end}{A numeric value indicating the last year of the 
reference period.}

\item{time_dim}{A character string indicating the daily time dimension name. 
The default value is 'time'.}

\item{sdate_dim}{A character string indicating the start year dimension name. 
The default value is 'sdate'.}

\item{title}{The text for the top title of the plot.}

\item{palette}{A palette name from the R Color Brewer’s package. The default 
value is 'Blues'.}

\item{fileout}{A character string indicating the file name where to save the 
plot. If not specified (default) a graphics device will pop up.}

\item{device}{A character string indicating the device to use. Can either be 
a device function (e.g. png), or one of "eps", "ps", "tex" (pictex), 
"pdf", "jpeg", "tiff", "png", "bmp", "svg" or "wmf" (windows only).}

\item{width}{A numeric value of the plot width in units ("in", "cm", "mm", or 
"px"). It is set to 8 by default.}

\item{height}{A numeric value of the plot height in units ("in", "cm", "mm", 
or "px"). It is set to 6 by default.}

\item{units}{Units of the size of the device (file or window) to plot in. 
Inches (’in’) by default.}

\item{dpi}{A numeric value of the plot resolution. It is set to 300 by 
default.}
}
\value{
A ggplot object containing the plot.
}
\description{
This function plots the observed weekly means and climatology of 
a timeseries data using ggplot package. It compares the weekly climatology in 
a specified period (reference period) to the observed conditions during the 
target period analyzed in the case study (included in the reference period).
}
\examples{
data <- array(rnorm(49*20, 274, 7), dim = c(time = 49, sdate = 20))
PlotWeeklyClim(data = data, first_date = '2010-08-09', 
              ref_period_ini = 1998,
              ref_period_end = 2020)

}
