% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_polar_plot_peaks.R
\name{ch_polar_plot_peaks}
\alias{ch_polar_plot_peaks}
\title{Polar / circular plots of peak flows}
\usage{
ch_polar_plot_peaks(
  title = NA,
  direction = NULL,
  regularity = NULL,
  days = NULL,
  shading = FALSE,
  shade = 35,
  pt_col = "darkblue",
  in_pch = NULL,
  in_cex = NULL,
  in_col = NULL,
  in_detail = NULL,
  labels = NULL,
  label_pos = NULL,
  out_pch = 16,
  out_cex = 0.8,
  ...
)
}
\arguments{
\item{title}{a title to be added to the plot}

\item{direction}{a value or array of mean/median direction, circular mean or 
median of points from ch_circ_mean_reg (optional)}

\item{regularity}{a value or array of regularity from ch_circ_mean_reg (optional).}

\item{days}{an array of days of year to be plotted on perimeter (optional).}

\item{shading}{if  \code{TRUE} adds shading and labels for nival and pluvial regimes default = \code{FALSE}}

\item{shade}{percentage of shading, default is 35.}

\item{pt_col}{colour used for points for events. default = "darkblue". If pt_col is an array it is used to colour 
the individual points of days}

\item{in_pch}{a value or an array of symbols to be used for centroids.  To be in color, 
must be one of 21 to 25 to get a symbol with border, elsewise a red symbol is plotted.}

\item{in_cex}{an array of symbol sizes}

\item{in_col}{an array of colors, either numbers or names to apply to centroid points (optional, 
default is "red")}

\item{in_detail}{an array of indices indicating symbol [1] shape, [2] colour, [3] background, 
and [4]size}

\item{labels}{an array of labels to be placed beside points with direction and regularity (optional)}

\item{label_pos}{an array of positions indicating when label be placed (1, 2, 3, or 4 - below, left, 
above, right)(optional - default is below)}

\item{out_pch}{symbols for points on outside of circle}

\item{out_cex}{point size for symbol}

\item{...}{other plot options}
}
\value{
Creates a circular plot of peak flows.
}
\description{
Polar / circular plots of peak flows.  
  Creates a polar plot of flow peaks in one of several different forms.  
   Basic plot has shading for nival and pluvial centroids.
}
\note{
points inside the plot

in_pch, in_col, and in_cex will normally be of the same length and that would 
be the maximum index of in_detail

points on the outside
}
\examples{
# base plot
ch_polar_plot_peaks() 

#base plot with area shading
ch_polar_plot_peaks(shading = TRUE)

# plot of annual maximum series
data(CAN05AA008)
am <- ch_sh_get_amax(CAN05AA008)
ch_polar_plot_peaks(days = am$doy, title = "05AA008")

#remove partial years
am <-am[am$days >= 365,]
ch_polar_plot_peaks(days = am$doy, title = "05AA008")

#plot the centroid
m_r <- ch_circ_mean_reg(am)
ch_polar_plot_peaks(direction = m_r$mean, regularity = m_r$regularity, title = "05AA008")

# plot peaks and centroid
ch_polar_plot_peaks(days = am$doy, direction = m_r$mean, regularity = m_r$regularity, 
title = "05AA008")
}
\references{
Pewsey, A., M. Neuhauser, and G. D. Ruxton. 2014. Circular Statistics in R, 
 192 pp., Oxford University Press.
 
 Whitfield, P. H. 2018. Clustering of seasonal events: A simulation study using 
 circular methods. Communications in Statistics - Simulation and Computation 47(10): 3008-3030.
 
 Burn, D. H., and P. H. Whitfield. 2023. Changes in the timing of flood events resulting 
 from climate change. Journal of Hydrology.
}
\author{
Paul Whitfield
}
