% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer.R
\name{infer.sample}
\alias{infer.sample}
\title{Inference method using sampling}
\usage{
infer.sample(crf, sample.method, ...)
}
\arguments{
\item{crf}{The CRF}

\item{sample.method}{The sampling method}

\item{...}{The parameters for \code{sample.method}}
}
\value{
This function will return a list with components:
  \item{node.bel}{Node belief. It is a matrix with \code{crf$n.nodes} rows and \code{crf$max.state} columns.}
  \item{edge.bel}{Edge belief. It is a list of matrices. The size of list is \code{crf$n.edges} and 
    the matrix \code{i} has \code{crf$n.states[crf$edges[i,1]]} rows and \code{crf$n.states[crf$edges[i,2]]} columns.}
  \item{logZ}{The logarithmic value of CRF normalization factor Z.}
}
\description{
Computing the partition function and marginal probabilities
}
\details{
Approximate inference using sampling (takes a sampling method as input)
}
\examples{

library(CRF)
data(Small)
i <- infer.sample(Small$crf, sample.exact, 10000)

}
