% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{removeOutliers}
\alias{removeOutliers}
\title{This function removes outliers from data. Outliers are removed if data have more than two replicates.
Outlier is defined as an observation that has maximum contribution to data CV when CV is higher than a
user defined threshold.}
\usage{
removeOutliers(arrangeReplicates, minThersholdForCVCal, minThersholdForCV)
}
\arguments{
\item{arrangeReplicates}{A data matrix.}

\item{minThersholdForCVCal}{CV threshold for outlier definition.}

\item{minThersholdForCV}{Threshold of survival values to be excluded from CV calculation.}
}
\value{
Data with out outliers.
}
\description{
This function removes outliers from data. Outliers are removed if data have more than two replicates.
Outlier is defined as an observation that has maximum contribution to data CV when CV is higher than a
user defined threshold.
}
\examples{
dataFile <- system.file("/raw/rawDataPreProcessed.csv", package="COMBIA")
dataSample <- read.csv(dataFile, header=FALSE )
minThersholdForCV <- 0.3
minThersholdForCVCal <- 0.1
removeOutliers( as.matrix(dataSample ) ,minThersholdForCV,
       minThersholdForCVCal)
}
\author{
Muhammad kashif
}

